/** @type {import('next').NextConfig} */
const nextConfig = {
  output: 'export',
  trailingSlash: true,
  reactStrictMode: false, // Disabled for static export
  images: {
    unoptimized: true,
    alt: 'Asiaporter China Sourcing Platform',
  },
  experimental: {
    optimizePackageImports: ['lucide-react', 'recharts'],
  },
  // Disable server-side features for static export
  env: {
    CUSTOM_KEY: 'asiaporter-static-export',
  },
}

module.exports = nextConfig
