# Asiaporter Platform - Testing Plan

## Test Plan Overview
**Website Type**: MPA (Multi-Page Application)
**Deployed URL**: [To be added after deployment]
**Test Date**: 2025-11-02
**Platform**: Next.js with Supabase Backend

## Pre-Deployment Requirements

### 1. Deployment Steps
1. Deploy to Vercel/Netlify (Node.js >=20.9.0 environment)
2. Configure environment variables:
   - `NEXT_PUBLIC_SUPABASE_URL`
   - `NEXT_PUBLIC_SUPABASE_ANON_KEY`
3. Verify successful build and deployment
4. Access deployed URL

### 2. Initial Setup
1. Create test user accounts:
   - Client user: `testclient@asiaporter.com`
   - Admin user: `testadmin@asiaporter.com`
   - Super admin user: `superadmin@asiaporter.com`

2. Update admin roles in database:
```sql
UPDATE ap_profiles 
SET role = 'admin' 
WHERE email = 'testadmin@asiaporter.com';

UPDATE ap_profiles 
SET role = 'super_admin' 
WHERE email = 'superadmin@asiaporter.com';
```

## Test Pathways

### Pathway 1: Public Website Navigation ✓
**Objective**: Verify all public pages and navigation work correctly

**Steps**:
1. Visit homepage
2. Check hero section displays correctly
3. Scroll through services section (8 services)
4. Verify statistics display (4 stat cards)
5. Check process steps (6 steps)
6. View testimonials section (3 testimonials)
7. Scroll to about section
8. Navigate using header menu
9. Test mobile menu (on mobile viewport)
10. Verify footer links and content

**Expected Results**:
- All sections visible and properly styled
- Navigation links work
- Mobile menu functions correctly
- Images/icons display properly
- Responsive design works on all viewports

---

### Pathway 2: User Registration Flow ✓
**Objective**: Test new user signup process

**Steps**:
1. Click "Login" in header
2. Click "Don't have an account? Sign up"
3. Enter full name: "Test Client"
4. Enter email: "testclient@asiaporter.com"
5. Enter password: "TestPassword123"
6. Click "Create Account"
7. Verify success message appears
8. Check Supabase Auth dashboard for user creation
9. Check ap_profiles table for profile creation

**Expected Results**:
- Form validation works
- Account created successfully
- Profile automatically created with "client" role
- Success message displayed
- Redirected appropriately

---

### Pathway 3: Client Login & Dashboard Access ✓
**Objective**: Verify authentication and client dashboard

**Steps**:
1. Go to `/login`
2. Enter client email and password
3. Click "Sign In"
4. Verify redirect to `/dashboard`
5. Check dashboard layout:
   - Welcome message with user name
   - 4 statistics cards
   - Recent projects section
   - Recent quotes section
   - Recent messages section
6. Click navigation elements
7. Test sign out button

**Expected Results**:
- Login successful
- Dashboard loads with correct data
- Statistics display accurately
- Empty states show when no data
- Sign out works correctly

---

### Pathway 4: Admin Panel Access ✓
**Objective**: Verify admin authentication and panel access

**Steps**:
1. Log in as admin user
2. Navigate to `/admin`
3. Verify admin dashboard displays:
   - 6 statistics cards
   - Overview tab with recent data
   - Tabs: Overview, Clients, Projects, Suppliers, Quotes, Invoices
4. Click each tab and verify content:
   - Clients: User table with all profiles
   - Projects: Project cards with status
   - Suppliers: Supplier grid (5 sample suppliers)
   - Quotes: Quote management interface
   - Invoices: Invoice table
5. Test sign out

**Expected Results**:
- Admin can access admin panel
- Regular clients cannot access admin panel (redirected to /dashboard)
- All tabs load correctly
- Sample data displays properly
- Tables and cards render correctly

---

### Pathway 5: Super Admin Full Access ✓
**Objective**: Verify super admin has access to all features

**Steps**:
1. Log in as super admin
2. Access `/admin` panel
3. Verify all admin features available
4. Check client management table shows all users
5. Verify can view all projects regardless of assignment
6. Test supplier database access
7. Verify invoice management access
8. Check analytics dashboard

**Expected Results**:
- Super admin has full access
- Can view all client data
- All management interfaces functional
- No permission restrictions

---

### Pathway 6: Project Creation Workflow (Future)
**Objective**: Test project creation and management

**Steps**:
1. As client, request new project
2. As admin, receive and review request
3. Create project record
4. Assign admin to project
5. Update project status
6. Client views project in dashboard
7. Track project through status stages

**Expected Results**:
- Projects created successfully
- Status updates reflected immediately
- Both client and admin see correct data
- RLS policies enforce proper access

---

### Pathway 7: Quote Management Workflow (Future)
**Objective**: Test quote request and response

**Steps**:
1. Client requests quote
2. Admin views pending quote requests
3. Admin creates quote with pricing
4. Client receives and views quote
5. Client accepts or rejects quote
6. Status updates correctly

**Expected Results**:
- Quote requests captured
- Admins can generate quotes
- Clients can view their quotes
- Status transitions work correctly

---

### Pathway 8: Communication System (Future)
**Objective**: Test message exchange between clients and admins

**Steps**:
1. Client sends message to admin
2. Admin receives notification
3. Admin replies to message
4. Client receives reply
5. Message history maintained

**Expected Results**:
- Messages sent and received
- Unread indicators work
- Message history accessible
- Both parties can communicate

---

### Pathway 9: Document Management (Requires Implementation)
**Objective**: Test file upload and document access

**Steps**:
1. Client uploads document to project
2. Document stored in Supabase Storage
3. Document metadata saved to ap_documents
4. Admin views uploaded document
5. Admin uploads additional documents
6. Client accesses all project documents

**Expected Results**:
- Files upload successfully
- Storage limits enforced
- File types validated
- Proper access control
- Download functionality works

---

### Pathway 10: Responsive Design Verification ✓
**Objective**: Ensure mobile-first design works across devices

**Viewports to Test**:
- Mobile: 375x667 (iPhone SE)
- Tablet: 768x1024 (iPad)
- Desktop: 1920x1080 (Full HD)

**Pages to Test**:
1. Homepage
2. Login page
3. Client dashboard
4. Admin panel

**Elements to Check**:
- Navigation menu (hamburger on mobile)
- Tables (scroll or stack on mobile)
- Forms (proper input sizing)
- Cards and grids (responsive columns)
- Typography (readable on all sizes)

**Expected Results**:
- All pages responsive
- No horizontal scroll on mobile
- Touch targets properly sized
- Content readable on all devices
- Navigation functional on all sizes

---

## Cross-Cutting Concerns

### Security Testing
- [ ] Non-authenticated users cannot access protected routes
- [ ] Clients cannot access admin panel
- [ ] Admins cannot access super admin functions (if role-based)
- [ ] RLS policies enforce data isolation
- [ ] XSS protection works
- [ ] CSRF tokens in place

### Performance Testing
- [ ] Homepage loads in <3 seconds
- [ ] Dashboard data loads quickly
- [ ] No memory leaks in long sessions
- [ ] Images optimized and load efficiently
- [ ] API calls don't cause blocking

### Error Handling
- [ ] Form validation shows clear errors
- [ ] Network errors handled gracefully
- [ ] 404 pages for invalid routes
- [ ] Database errors don't crash application
- [ ] User-friendly error messages

## Testing Checklist

### Phase 1: Initial Deployment ✓
- [x] Code complete
- [ ] Deployed to production environment
- [ ] Environment variables configured
- [ ] Database connected
- [ ] Storage bucket accessible

### Phase 2: Core Functionality
- [ ] User registration works
- [ ] Login/logout works
- [ ] Client dashboard loads
- [ ] Admin panel loads
- [ ] Role-based access enforced
- [ ] Sample data displays correctly

### Phase 3: Data Operations
- [ ] Projects can be created (by admin)
- [ ] Quotes can be generated
- [ ] Invoices can be created
- [ ] Suppliers can be added/edited
- [ ] Messages can be sent/received

### Phase 4: File Operations (Requires Implementation)
- [ ] Documents can be uploaded
- [ ] Files stored in Supabase Storage
- [ ] Documents can be downloaded
- [ ] File type validation works
- [ ] Size limits enforced

### Phase 5: UI/UX Verification
- [ ] Mobile responsive on all pages
- [ ] Navigation intuitive
- [ ] Forms user-friendly
- [ ] Status indicators clear
- [ ] Error messages helpful

### Phase 6: Security Verification
- [ ] Protected routes secure
- [ ] RLS policies effective
- [ ] No unauthorized data access
- [ ] Session management secure
- [ ] XSS/CSRF protection in place

## Known Issues & Limitations

### Current Limitations
1. **File Upload**: UI ready but backend integration needed
2. **Email Notifications**: Foundation laid, SMTP configuration needed
3. **Real-time Updates**: Can be added with Supabase Realtime
4. **Search Functionality**: Not yet implemented
5. **Advanced Filters**: Basic filtering only

### Environment Notes
- Local development requires Node.js >=20.9.0
- Build tested on deployment platforms (Vercel/Netlify)
- All code TypeScript-checked and lint-free

## Bug Tracking Template

| ID | Severity | Description | Status | Fixed In | Re-test Result |
|----|----------|-------------|--------|----------|----------------|
| 001 | High | [description] | Open | - | - |
| 002 | Medium | [description] | Fixed | [commit/deploy] | Pass/Fail |
| 003 | Low | [description] | Fixed | [commit/deploy] | Pass/Fail |

**Severity Levels**:
- **Critical**: Application unusable
- **High**: Core feature broken
- **Medium**: Feature impaired but workaround exists
- **Low**: Minor issue, cosmetic

## Post-Testing Actions

### If All Tests Pass
1. Document test completion
2. Create user documentation
3. Prepare for production launch
4. Set up monitoring and analytics
5. Create backup procedures

### If Issues Found
1. Document all bugs with severity
2. Prioritize fixes (Critical > High > Medium > Low)
3. Fix bugs in batch
4. Re-deploy
5. Re-test affected pathways only
6. Verify fixes work correctly

## Success Criteria

The platform is considered fully tested and production-ready when:
- ✓ All 10 pathways pass completely
- ✓ No critical or high severity bugs remain
- ✓ Security tests pass
- ✓ Performance meets targets
- ✓ Responsive design verified
- ✓ Documentation complete

## Next Steps After Testing

1. **Implement File Uploads**: Connect UI to Supabase Storage
2. **Add Email Notifications**: Configure SMTP and templates
3. **Enhance Search**: Add filtering and search functionality
4. **Add Analytics**: Implement business metrics tracking
5. **Create Admin Tools**: Bulk operations, data export
6. **Multi-language**: Add Chinese language support
7. **Mobile App**: Consider React Native application

## Testing Tools Recommendation

- **Automated Testing**: Playwright or Cypress
- **Performance**: Lighthouse, WebPageTest
- **Security**: OWASP ZAP, Security Headers
- **Monitoring**: Sentry, LogRocket
- **Analytics**: Vercel Analytics, Google Analytics

## Conclusion

This testing plan provides comprehensive coverage of the Asiaporter platform. Follow the pathways systematically, document issues carefully, and verify fixes thoroughly. The platform is well-architected and should pass all tests once properly deployed.
