# Asiaporter Platform

A comprehensive China sourcing company platform with client portal and super admin panel.

## Features

### Main Website (Public)
- Professional marketing homepage
- Service showcase (8 core services)
- How It Works process flow
- Client testimonials
- Contact form
- Mobile-responsive design

### Client Dashboard
- Project tracking
- Quote management
- Message center
- Document access
- Invoice viewing

### Super Admin Panel
- Client management
- Project oversight
- Supplier database
- Quote generation
- Financial management
- Business analytics

## Tech Stack

- **Frontend**: Next.js 14, React 18, TypeScript, Tailwind CSS
- **Backend**: Supabase (PostgreSQL database, Auth, Storage)
- **Icons**: Lucide React
- **Charts**: Recharts

## Database Schema

All tables use `ap_` prefix:
- `ap_profiles` - User profiles with role-based access
- `ap_projects` - Sourcing projects/orders
- `ap_quotes` - Quote requests and responses
- `ap_suppliers` - Supplier database
- `ap_invoices` - Invoicing and payments
- `ap_documents` - Document metadata
- `ap_messages` - Communication hub
- `ap_service_requests` - Service inquiries
- `ap_inspections` - Quality control records
- `ap_shipments` - Logistics tracking

## User Roles

1. **Visitor** - Public access to marketing site
2. **Client** - Access to client dashboard
3. **Admin** - Project management access
4. **Super Admin** - Full platform access

## Setup Instructions

### Prerequisites
- Node.js >= 20.9.0
- pnpm package manager
- Supabase account

### Environment Variables

Create `.env.local`:
```
NEXT_PUBLIC_SUPABASE_URL=your_supabase_url
NEXT_PUBLIC_SUPABASE_ANON_KEY=your_supabase_anon_key
```

### Installation

```bash
# Install dependencies
pnpm install

# Run development server
pnpm run dev

# Build for production
pnpm run build

# Start production server
pnpm start
```

## Deployment

### Option 1: Vercel (Recommended)
1. Connect repository to Vercel
2. Add environment variables
3. Deploy

### Option 2: Static Export
Add to `next.config.js`:
```javascript
output: 'export'
```
Then run `pnpm run build` and deploy the `out` folder.

### Option 3: Docker
```dockerfile
FROM node:20-alpine
WORKDIR /app
COPY package.json pnpm-lock.yaml ./
RUN npm install -g pnpm && pnpm install
COPY . .
RUN pnpm run build
EXPOSE 3000
CMD ["pnpm", "start"]
```

## Project Structure

```
asiaporter-platform/
├── app/
│   ├── page.tsx                 # Main marketing homepage
│   ├── layout.tsx              # Root layout with AuthProvider
│   ├── globals.css             # Global styles
│   ├── login/
│   │   └── page.tsx            # Login/Signup page
│   ├── dashboard/
│   │   └── page.tsx            # Client dashboard
│   └── admin/
│       └── page.tsx            # Super admin panel
├── lib/
│   ├── auth-context.tsx        # Authentication context
│   └── supabase/
│       └── client.ts           # Supabase client config
├── public/
├── docs/
│   └── database-schema.md      # Database documentation
└── package.json
```

## Features by Role

### Client Features
- View and track projects
- Request quotes
- Communicate with team
- Access documents
- View invoices

### Admin/Super Admin Features
- Manage clients
- Oversee all projects
- Supplier database management
- Create and send quotes
- Generate invoices
- View business analytics
- System configuration

## Sample Data

The database includes sample data for:
- 5 verified suppliers across different product categories
- 5 service requests from potential clients
- Ready for user registration and real project creation

## API Routes

All data access uses Supabase RLS (Row Level Security):
- Clients can only see their own data
- Admins can see all client data
- Public access for service requests

## Security

- Row Level Security (RLS) enabled on all tables
- Role-based access control
- Secure authentication via Supabase Auth
- Environment variable protection

## Support

For questions or issues, contact the development team.

## License

Proprietary - Asiaporter © 2025
